<?php

/**
* Javascript TemplatePlazza Gzip Loader
* TemplatePlazza.com 
**/
if (extension_loaded('zscripts') && !ini_get('zscripts.output_compression')) @ob_start('ob_gzhandler');
header('Content-type: text/css; charset: UTF-8');
header('Cache-Control: must-revalidate');
header('Expires: ' . gmdate('D, d M Y H:i:s', time() + 3600) . ' GMT');

define('DS', DIRECTORY_SEPARATOR);
define('PATH_ROOT', dirname(__FILE__) . DS);

$jsPath = PATH_ROOT;

//js path | js file name | js browser1
//js browser = "all" for all browser, "browser1,browser2,..." for defined various browser only
//IE = msie 6
//IE with various version = msie parent version or full version, e.g. "msie 6" or "msie 5.5" or "msie 5.0.1"
//IE 4 = msie 4
//IE 5 = msie 5
//IE 6 = msie 6
//IE 7 = msie 7
//IE 7 = msie 7
//Opera = opera
//Opera with various version = opera/version, e.g. "opera/9.10"
//Firefox = firefox
//Firefox with various version = firefox/version, e.g. "firefox/2.0.0.14"
// usage $jsGZIP[] = $jsPath."|js2.js|msie 6,msie 7";
// usage $jsGZIP[] = $jsPath."|js1.js|all";

$jsGZIP[] = $jsPath."|tab.js|all";
$jsGZIP[] = $jsPath."|template.js|all";

foreach($jsGZIP as $GZIP) {
	$js = explode("|", $GZIP);
	if($js[2]=="all") {
		include($js[0].$js[1]);
	} else {
		$browsers = explode(",", $js[2]);
		$loadThisJS = false;
		foreach($browsers as $browser) {
			if(strpos(strtolower($_SERVER['HTTP_USER_AGENT']), $browser) !== false) {
				$loadThisJS = true;
			}
		}
		if($loadThisJS == true) {
			include($js[0].$js[1]);
		}
	}
}

?>