<?php
/**
* @version 2.0
* @package PWebFBLinkArticleImages
* @copyright © 2013 Majestic Media sp. z o.o., All rights reserved. http://www.perfect-web.co
* @license GNU General Public Licence http://www.gnu.org/licenses/gpl-3.0.html
* @author Piotr Moćko
*/
defined('_JEXEC') or die( 'Restricted access' );

/**
 * Perfect-Web Popup Media Manager.
 *
 * @subpackage	plg_fblinkcontentimage
 * @since		1.5
 */
class JElementPwebMedia extends JElement
{
	/**
	 * Element name
	 *
	 * @access	protected
	 * @var		string
	 */
	 var	$_name = 'PwebMedia';
	 var	$_initialised = false;
	 var	$_initialised_tip = false;

	function fetchElement($name, $value, &$node, $control_name = 'params')
	{	
		// Initialize variables.
		$html = array();
		$fieldName	= $control_name.'['.$name.']';
		$fieldId	= $control_name.$name;
		
		if (!$this->_initialised)
		{

			// Load the modal behavior script.
			JHtml::_('behavior.modal');

			// Build the script.
			$script = array();
			$script[] = '	function jInsertEditorText(text,id) {';
			$script[] = '		var src = "";';
			$script[] = '		var img = text.match(/<img[^>]* src=["]([^"]+)"/i);';
			$script[] = '		if (img && typeof img[1] != "undefined") src = img[1];';
			$script[] = '		$(id).value = src;';
			$script[] = '		jMediaRefreshPreview(id);';
			$script[] = '	}';

			$script[] = '	function jMediaRefreshPreview(id) {';
			$script[] = '		var value = $(id).value;';
			$script[] = '		var img = $(id + "_preview");';
			$script[] = '		if (img) {';
			$script[] = '			if (value) {';
			$script[] = '				img.src = "' . JURI::root() . '" + value;';
			$script[] = '				$(id + "_preview_empty").setStyle("display", "none");';
			$script[] = '				$(id + "_preview_img").setStyle("display", "");';
			$script[] = '			} else { ';
			$script[] = '				img.src = ""';
			$script[] = '				$(id + "_preview_empty").setStyle("display", "");';
			$script[] = '				$(id + "_preview_img").setStyle("display", "none");';
			$script[] = '			} ';
			$script[] = '		} ';
			$script[] = '	}';

			$script[] = '	function jMediaRefreshPreviewTip(tip)';
			$script[] = '	{';
			$script[] = '		tip.setStyle("visibility", "visible");';
			$script[] = '		var img = tip.getElement("img.media-preview");';
			$script[] = '		var id = img.getProperty("id");';
			$script[] = '		id = id.substring(0, id.length - "_preview".length);';
			$script[] = '		jMediaRefreshPreview(id);';
			$script[] = '	}';

			// Add the script to the document head.
			$doc =& JFactory::getDocument();
			$doc->addScriptDeclaration(implode("\n", $script));

			$this->_initialised = true;
		}

		// Initialize some field attributes.
		$attr  = $node->attributes('class') ? ' class="' . (string) $node->attributes('class') . '"' : '';
		$attr .= $node->attributes('size') ? ' size="' . (int) $node->attributes('size') . '"' : '';
		$attr .= $node->attributes('readonly') ? ' readonly="readonly"' : '';

		// Initialize JavaScript field attributes.
		$attr .= $node->attributes('onchange') ? ' onchange="' . (string) $node->attributes('onchange') . '"' : '';
		
		$directory = (string) $node->attributes('directory');
		$params_media =& JComponentHelper::getParams('com_media');
		$media_path = $params_media->get('image_path', 'images/stories');
		$value  = ltrim($value, '/');
		if ($value && strpos($value, $media_path) === 0 && file_exists(JPATH_ROOT . '/' . $value))
		{
			$folder = explode('/', str_replace($media_path.'/', '', $value));
			array_pop($folder);
			$folder = implode('/', $folder);
		}
		elseif (file_exists(JPATH_ROOT . '/' . $media_path . '/' . $directory))
		{
			$folder = $directory;
		}
		else
		{
			$folder = '';
		}
		
		$js_clear = "jInsertEditorText('','$fieldId');return false;";
		
		$link = 'index.php?option=com_media&amp;view=images&amp;layout=default&amp;tmpl=component&amp;e_name='.$fieldId;
		if ($folder) $link .= '&amp;folder='.$folder;
		
		// The button.
		$html[] = '<div style="float: left;"><input type="text" id="'.$fieldId.'" name="'.$fieldName.'" value="'.htmlspecialchars($value, ENT_QUOTES, 'UTF-8').'"' . $attr . ' /></div>';
		$html[] = '<div class="button2-left"><div class="blank"><a class="modal" title="'.JText::_('Select Image').'"  href="'.$link.'" rel="{handler: \'iframe\', size: {x: 570, y: 400}}">'.JText::_('Select').'</a></div></div>';
		$html[] = '<div class="button2-left"><div class="blank"><a href="#" onclick="'.$js_clear.'">'.JText::_('Reset').'</a></div></div>';

		// The Preview.
		$preview = (string) $node->attributes('preview');
		$showPreview = true;
		$showAsTooltip = false;
		switch ($preview)
		{
			case 'false':
			case 'none':
				$showPreview = false;
				break;
			case 'true':
			case 'show':
				break;
			case 'tooltip':
			default:
				$showAsTooltip = true;
				if (!$this->_initialised_tip)
				{
					$this->_initialised_tip = true;
					JHtml::_('behavior.tooltip');
					$script = array();
					$script[] = '	window.addEvent("domready", function(){';
					$script[] = '		var JTooltipsPreview = new Tips($$(".hasTipPreview"), {maxTitleChars: 50, fixed: false, onShow: jMediaRefreshPreviewTip});';
					$script[] = '	});';
					$doc =& JFactory::getDocument();
					$doc->addScriptDeclaration(implode("\n", $script));
				}
				break;
		}

		if ($showPreview)
		{
			if ($value && file_exists(JPATH_ROOT . '/' . $value))
			{
				$src = JURI::root() . $value;
			}
			else
			{
				$src = '';
			}

			$attr = array(
				'id' => $fieldId . '_preview',
				'class' => 'media-preview',
				'style' => 'max-width:160px; max-height:100px;'
			);
			$img = JHtml::image($src, JText::_('Preview'), $attr);
			$previewImg = '<div id="' . $fieldId . '_preview_img"' . ($src ? '' : ' style="display:none"') . '>' . $img . '</div>';
			$previewImgEmpty = '<div id="' . $fieldId . '_preview_empty"' . ($src ? ' style="display:none"' : '') . '>'
				. JText::_('Not found') . '</div>';

			$html[] = '<div class="media-preview fltlft">';
			if ($showAsTooltip)
			{
				$tooltip = addslashes(htmlspecialchars($previewImgEmpty . $previewImg, ENT_QUOTES, 'UTF-8'));
				$html[] = '<div class="button2-left"><div class="blank"><a href="#" onclick="return false;" class="hasTipPreview" title="'.JText::_('Preview').'::'.$tooltip.'">'.JText::_('Preview').'</a></div></div>';
			}
			else
			{
				$html[] = ' ' . $previewImgEmpty;
				$html[] = ' ' . $previewImg;
			}
			$html[] = '</div>';
		}

		return implode("\n", $html);
	}
}