<?php
/**
* @version 2.0.1
* @package PWebFBLinkArticleImages
* @copyright © 2013 Majestic Media sp. z o.o., All rights reserved. http://www.perfect-web.co
* @license GNU General Public Licence http://www.gnu.org/licenses/gpl-3.0.html
* @author Piotr Moćko
*/
defined('_JEXEC') or die( 'Restricted access' );

/**
 * Perfect-Web Categories multiple select.
 *
 * @subpackage	plg_fblinkcontentimage
 * @since		1.5
 */
class JElementPwebCategory extends JElement
{
	/**
	 * Element name
	 *
	 * @access	protected
	 * @var		string
	 */
	 var	$_name = 'PwebCategory';

	function fetchElement($name, $value, &$node, $control_name)
	{
		$db = &JFactory::getDBO();

		$section	= $node->attributes('section');
		$class		= $node->attributes('class');
		if (!$class) {
			$class = 'inputbox';
		}

		if (!isset ($section)) {
			// alias for section
			$section = $node->attributes('scope');
			if (!isset ($section)) {
				$section = 'content';
			}
		}

		if ($section == 'content') {
			// This might get a conflict with the dynamic translation - TODO: search for better solution
			$query = 'SELECT c.id, CONCAT_WS( "/",s.title, c.title ) AS title' .
				' FROM #__categories AS c' .
				' LEFT JOIN #__sections AS s ON s.id=c.section' .
				' WHERE c.published = 1' .
				' AND s.scope = '.$db->Quote($section).
				' ORDER BY s.title, c.title';
		} else {
			$query = 'SELECT c.id, c.title' .
				' FROM #__categories AS c' .
				' WHERE c.published = 1' .
				' AND c.section = '.$db->Quote($section).
				' ORDER BY c.title';
		}
		$db->setQuery($query);
		$options = $db->loadObjectList();
		array_unshift($options, JHTML::_('select.option', '0', '- '.JText::_('Select Category').' -', 'id', 'title'));
		
		$attribs = 'class="'.$class.'"';
		$multiple = $node->attributes('multiple');
		if ($multiple == 'true') 
			$attribs .= ' multiple="multiple"';
		if ($node->attributes('size')) 
			$attribs .= ' size="'.$node->attributes('size').'"';
		if ($node->attributes('disabled') == 'true') 
			$attribs .= ' disabled="disabled"';

		return JHTML::_('select.genericlist', $options, $control_name.'['.$name.']'.($multiple == 'true' ? '[]' : ''), $attribs, 'id', 'title', $value, $control_name.$name );
	}
}