<?php
/**
* @version 2.0.7
* @package PWebFBLinkArticleImages
* @copyright © 2013 Majestic Media sp. z o.o., All rights reserved. http://www.perfect-web.co
* @license GNU General Public Licence http://www.gnu.org/licenses/gpl-3.0.html
* @author Piotr Moćko
*/

defined('_JEXEC') or die( 'Restricted access' );

jimport('joomla.html.parameter.element.radio');

/**
 * Perfect-Web
 *
 * @subpackage	plg_fblinkcontentimage
 * @since		1.5
 */
class JElementPweb extends JElementRadio
{
	/**
	 * Element name
	 *
	 * @access	protected
	 * @var		string
	 */
	var	$_name = 'Pweb';
	var $extension = 'plg_fblinkcontentimage_core';
	var $documentation = 'http://www.perfect-web.co/joomla/plugins/link-with-article-images-facebook/documentation';
	var $home = 'http://www.perfect-web.co/joomla/plugins/link-with-article-images-facebook';
	
	function fetchElement($name, $value, &$node, $control_name = 'params')
	{		
		$app =& JFactory::getApplication();
		$doc =& JFactory::getDocument();
		
		// add documentation and upgrade toolbar button
		$button = '<a href="'.$this->documentation.'" style="font-weight:bold;border-color:#025A8D;background-color:#DBE4E9;" target="_blank"><span class="icon-32-help"> </span> '.JText::_('PLG_PWEB_FBARTICLEIMAGES_DOCUMENTATION').'</a>';
		
		$button_upgrade = '<a href="'.$this->home.'" style="font-weight:bold;border-color:#025A8D;background-color:#DBE4E9;" target="_blank"><span class="icon-32-upload"> </span> '.JText::_('PLG_PWEB_FBARTICLEIMAGES_UPGRADE_PRO').'</a>';
		
		$bar =& JToolBar::getInstance();
		$bar->appendButton('Custom', $button, $this->extension.'-docs');
		$bar->appendButton('Custom', $button_upgrade, $this->extension.'-upgrade');
		
		// Check if SEF is enabled
		if (!$app->getCfg('sef')) 
		{
			$app->enqueueMessage('Enable <a href="index.php?option=com_config" onclick="Cookie.set(\'configuration\',\'site\')" target="_blank"><u>Search Engine Friendly URLs</u></a> in SEO Settings on Site tab for better experience on Facebook', 'warning');
		}
		
		// Core version disabled fields
		JHtml::_('behavior.mootools');
		$doc->addScriptDeclaration(
			'window.addEvent("domready",function(){'.
				'$$("form[name=adminForm] .disabled").setProperty("disabled","disabled");'.
				'$$("#paramsadd_og_tags2, #paramsimages_limit2, #paramsfb_like1, #paramsfb_like2, #paramsfb_position1, #paramsfb_position2, #paramsfb_alignleft, #paramsfb_alignright, #paramsfb_send0, #paramsfb_send1, #paramsfb_layoutstandard, #paramsfb_layoutbutton_count, #paramsfb_layoutbox_count, #paramsfb_show_faces0, #paramsfb_show_faces1, #paramsfb_actionlike, #paramsfb_actionrecommend, #paramsfb_colorschemelight, #paramsfb_colorschemedark, #paramsfb_jssdk0, #paramsfb_jssdk1, #paramsfb_root0, #paramsfb_root1, #paramstrack_social0, #paramstrack_social1, #paramstrack_social2").setProperty("disabled","disabled").each(function(el){'.
					'$$("label[for="+el.getProperty("id")+"]").addClass("disabled")'.
				'});'.
			'});'
		);
		$doc->addStyleDeclaration(
			'label.disabled{color:#aaa}'
		);
		
		// add feed script
		if ($value)
		{
			$doc->addScriptDeclaration(
				'(function(){'.
				'var pw=document.createElement("script");pw.type="text/javascript";pw.async=true;'.
				'pw.src="//www.perfect-web.co/updates/feed.js?ext='.$this->extension.'&j='.JVERSION.'";'.
				'var s=document.getElementsByTagName("script")[0];s.parentNode.insertBefore(pw,s);'.
				'})();'
			);
		}
		
		return parent::fetchElement($name, $value, $node, $control_name);
	}
}
