<?php
	/**
	* TemplatePlazza
	* TemplatePlazza.com 
	**/
	defined('_JEXEC') or die('Restricted access');
	require_once(JPATH_ADMINISTRATOR.DS.'components'.DS.'com_banners'.DS.'helpers'.DS.'banner.php');

	class modTPSlideHelper{
		function getList(&$params){
			$model		= modTPSlideHelper::getModel();
			$vars['cid']		= (int) $params->get( 'cid' );
			$vars['catid']		= (int) $params->get( 'catid' );
			$vars['limit']		= (int) $params->get( 'count', 1 );
			$vars['ordering']	= $params->get( 'ordering' );
	
			if($params->get( 'tag_search' )){
				$document		=& JFactory::getDocument();
				$keywords		=  $document->getMetaData( 'keywords' );
				$vars['tag_search'] = BannerHelper::getKeywords( $keywords );
			}
			$banners = $model->getList( $vars );
			$model->impress( $banners );
	
			return $banners;
		}
	
		function getModel(){
			if(!class_exists( 'BannersModelBanner' )){
				// Build the path to the model based upon a supplied base path
				$path = JPATH_SITE.DS.'components'.DS.'com_banners'.DS.'models'.DS.'banner.php';
				$false = false;
	
				// ifthe model file exists include it and try to instantiate the object
				if(file_exists( $path )){
					require_once( $path );
					if(!class_exists( 'BannersModelBanner' )){
						JError::raiseWarning( 0, 'Model class BannersModelBanner not found in file.' );
						return $false;
					}
				}else{
					JError::raiseWarning( 0, 'Model BannersModelBanner not supported. File not found.' );
					return $false;
				}
			}
	
			$model = new BannersModelBanner();
			return $model;
		}
	
		function renderBanner($params, &$item){
			$link = JRoute::_( 'index.php?option=com_banners&task=click&bid='. $item->bid );
			$baseurl = JURI::base();
	
			$html = '';
			if(BannerHelper::isImage( $item->imageurl )){
				$image 	= '<img src="'.$baseurl.'images/banners/'.$item->imageurl.'" alt="'.JText::_('Banner').'" />';
				if($item->clickurl){
					switch ($params->get( 'target', 1 )){
						// cases are slightly different
						case 1:
							// open in a new window
							$a = '<a href="'. $link .'" target="_blank">';
							break;
	
						case 2:
							// open in a popup window
							$a = "<a href=\"javascript:void window.open('". $link ."', '', 'toolbar=no,location=no,status=no,menubar=no,scrollbars=yes,resizable=yes,width=780,height=550'); return false\">";
							break;
	
						default:	// formerly case 2
							// open in parent window
							$a = '<a href="'. $link .'">';
							break;
						}
	
					$html = $a . $image . '</a>';
				}else{
					$html = $image;
				}
			}
			return $html;
		}
	}
?>